<?php 
session_start();

require("config/conn.php");
require("functions.php");
include("includes/header.php");
include("includes/topbar.php");
include("includes/sidebar.php");


session_regenerate_id(true);

if (!isset($_SESSION['AdminLoginId'])) {
    header("Location: index.php");
} 
?>



<main>
    <div class="container-fluid px-4">

        <h1 class="mt-4 dash-heading">Users</h1>
        <ol class="breadcrumb mb-4">
            <li class="breadcrumb-item active">Users</li>
        </ol>



        <div class="row mb-4">

            <div class="user-table">

                <div class="useractioncontainer d-flex align-items-center justify-content-between">
                    <a herf="javascript:void(0)" onclick="delete_all()" class="delete-user-btn">Delete Selected
                        Users</a>

                        <div class="dropdown">
                            <a class="download-data-btn dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                                Download
                            </a>
                            
                            <ul class="dropdown-menu">
                                <li><a class="dropdown-item" href="export.php?export_user_csv=true">CSV</a></li>
                                <li><a class="dropdown-item"  href="export.php?export_user_excel=true" href="#">Excel</a></li>
                                <li><a class="dropdown-item" href="export.php?export_user_pdf=true">PDF</a></li>
                            </ul>
                            </div>
                </div>
                <form method="post" id="frm">
                    <table id="example" class="table table-striped" style="width:100%">
                        <thead>
                            <tr>
                                <th class="hide-sort"><input type="checkbox" onclick="select_all()" id="delete"></th>
                                <th>SR No.</th>
                                <th>Avatar</th>
                                <th>Name</th>
                                <th>Email</th>
                                <th>Account Created</th>
                                <th>Status</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
            
            $sql = "SELECT * FROM `users`";

            $query_run = mysqli_query($conn, $sql);

            if ($query_run):
                if (mysqli_num_rows($query_run) > 0):

                    $i = 1;

                    foreach ($query_run as $row):
                        if ($row['isBanned'] == 0):
                            $text = "Active";
                            $style = "active";
                        else:
                            $text = "Banned";
                            $style = "banned";
                        endif;
                        ?>



                            <tr id="box<?= $row['id']; ?>">
                                <td><input type="checkbox" name="checkbox[]" value="<?= $row['id']; ?>"
                                        id="<?= $row['id']; ?>"></td>
                                <td>
                                    <?= $i; ?>
                                </td>
                                <td><img style="width: 50px; height: 50px;" src="<?= $row['avatar']; ?>" alt="avatar">
                                </td>
                                <td>
                                    <?= $row['name']; ?>
                                </td>
                                <td>
                                    <?= $row['email'] ?>
                                </td>
                                <td>
                                    <?=  date('d-M-Y',strtotime($row['accountCreated']))?>
                                </td>
                                <td class="d-flex align-items-center"><span class="<?= $style; ?>">
                                        <?= $text ?>
                                    </span></td>
                                <td>
                                    <div class="d-flex align-items-center">
                                        <a class="edit-user" href="user-edit.php?user_id=<?= $row['id']; ?>"><i class="fa-solid fa-pen-to-square"></i></a>
                                        
                                        <button
                                        
                                        class="delete-user delete-user" name="deleteUser" value="<?= $row['id']; ?>"><i class="fa-solid fa-trash"></i></button>
                                        
                                    </div>
                                </td>
                            </tr>


                            <?php

                        $i++;
                    endforeach;








                else:
                    echo "No User Data";
                endif;
            else:
                echo "Some Error Occured";
            endif;
            
            
            
            ?>

                        </tbody>
                    </table>
                </form>


            </div>
        </div>


        

    </div>

    <!-- Modal -->
<div class="modal fade" id="deleteModal" tabindex="-1" aria-labelledby="deleteModalLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h1 class="modal-title fs-5" id="deleteModalLabel">Delete User</h1>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
    </div>
    <form action="code.php" method="post">
      <div class="modal-body">
        <p>Are you sure to delete this user ?</p>
        <input type="hidden" name="del_id" class="delete-user-id" id="del_id">
      </div>
      <div class="modal-footer">

        <button type="submit" class="btn btn-primary delButton" name="delButton">Yes! Delete</button>
    </div>
</form>
    </div>
  </div>
</div>



</main>









<?php 

include("includes/script.php");

?>


<script>
    <?php

    if(isset($_SESSION['status'])){
    ?>
        swal("<?= $_SESSION['message']; ?>", {
            icon: "<?= $_SESSION['icon'] ?>",
            
        }
        );
    <?php
  unset($_SESSION['status']);
  unset($_SESSION['message']);
  unset($_SESSION['icon']);
}

?>

    
</script>


<script>
    $(document).ready(function () {
        var table = $('#example').DataTable({
            language: {
                searchPlaceholder: "Search Users"
            },
            columnDefs: [
                {
                    targets: 0,
                    checkboxes: {
                        selectRow: true
                    }
                }
            ],
            select: {
                style: 'multi'
            },
            order: [[1, 'asc']]

        });

    });



</script>
<script>





    function select_all() {
        if (jQuery('#delete').prop("checked")) {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', true);
                // console.log(this.id);
            });
        } else {
            jQuery('input[type=checkbox]').each(function (param) {
                jQuery('#' + this.id).prop('checked', false);
                // console.log(this.id);
            });
        }

    }




    function delete_all() {

        swal({
  title: "Are you sure?",
  text: "Are You Sure To Delete Users !",
  icon: "warning",
  buttons: ["Cancel", "Yes ! Delete"],
  dangerMode: true,
})
.then((willDelete) => {
  if (willDelete) {
    jQuery.ajax({
            type: "post",
            url: "code.php",
            data: jQuery("#frm").serialize(),
            success: function (response) {

                jQuery('input[type=checkbox]').each(function () {
                    if (jQuery('#' + this.id).prop("checked")) {
                        jQuery('#box' + this.id).remove();
                    }
                    swal({
                        title: "Users Deleted Successfully",
                        text: "Users Deleted",
                        icon: "success",
                    });
                });
            }
        });
  } else {
   
  }
});


        
    }


   


</script>



<script>
    $(document).ready(function () {
        $('.delete-user').click(function (e) {
            e.preventDefault();

            var id = $(this).val();
            // console.log(user_id);
            $('.delete-user-id').val(id);
            $('#deleteModal').modal('show')
        });
    });

</script>

<?php

include("includes/footer.php");


?>